var sysexDump = [
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x01, 0x07, 0x00, 0x24, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x02, 0x07, 0x00, 0x25, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x03, 0x07, 0x00, 0x26, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x04, 0x07, 0x00, 0x27, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x05, 0x07, 0x00, 0x28, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x06, 0x07, 0x00, 0x29, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x07, 0x07, 0x00, 0x2a, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x08, 0x07, 0x00, 0x2b, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x09, 0x07, 0x00, 0x2c, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x0a, 0x07, 0x00, 0x2d, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x0b, 0x07, 0x00, 0x2e, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x0c, 0x07, 0x00, 0x2f, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x0d, 0x07, 0x00, 0x30, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x0e, 0x07, 0x00, 0x31, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x0f, 0x07, 0x00, 0x32, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x10, 0x07, 0x00, 0x33, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x11, 0x07, 0x00, 0x24, 0x02, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x12, 0x07, 0x00, 0x25, 0x02, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x13, 0x07, 0x00, 0x26, 0x02, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x14, 0x07, 0x00, 0x27, 0x02, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x15, 0x07, 0x00, 0x28, 0x02, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x16, 0x07, 0x00, 0x29, 0x02, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x17, 0x07, 0x00, 0x2a, 0x02, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x18, 0x07, 0x00, 0x2b, 0x02, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x19, 0x07, 0x00, 0x2c, 0x02, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x1a, 0x07, 0x00, 0x2d, 0x02, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x1b, 0x07, 0x00, 0x2e, 0x02, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x1c, 0x07, 0x00, 0x2f, 0x02, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x1d, 0x07, 0x00, 0x30, 0x02, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x1e, 0x07, 0x00, 0x31, 0x02, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x1f, 0x07, 0x00, 0x32, 0x02, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x20, 0x07, 0x00, 0x33, 0x02, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x21, 0x07, 0x00, 0x24, 0x03, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x22, 0x07, 0x00, 0x25, 0x03, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x23, 0x07, 0x00, 0x26, 0x03, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x24, 0x07, 0x00, 0x27, 0x03, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x25, 0x07, 0x00, 0x28, 0x03, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x26, 0x07, 0x00, 0x29, 0x03, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x27, 0x07, 0x00, 0x2a, 0x03, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x28, 0x07, 0x00, 0x2b, 0x03, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x29, 0x07, 0x00, 0x2c, 0x03, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x2a, 0x07, 0x00, 0x2d, 0x03, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x2b, 0x07, 0x00, 0x2e, 0x03, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x2c, 0x07, 0x00, 0x2f, 0x03, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x2d, 0x07, 0x00, 0x30, 0x03, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x2e, 0x07, 0x00, 0x31, 0x03, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x2f, 0x07, 0x00, 0x32, 0x03, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x30, 0x07, 0x00, 0x33, 0x03, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x31, 0x03, 0x04, 0x40, 0x21, 0xf7],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x32, 0x03, 0x04, 0x41, 0x21, 0xf7],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x33, 0x03, 0x04, 0x42, 0x21, 0xf7],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x34, 0x03, 0x04, 0x43, 0x21, 0xf7],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x35, 0x03, 0x04, 0x44, 0x21, 0xf7],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x36, 0x03, 0x04, 0x45, 0x21, 0xf7],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x37, 0x03, 0x04, 0x46, 0x21, 0xf7],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x38, 0x03, 0x04, 0x47, 0x21, 0xf7],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x39, 0x03, 0x04, 0x48, 0x21, 0xf7],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x3a, 0x03, 0x04, 0x49, 0x21, 0xf7],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x3b, 0x03, 0x04, 0x4a, 0x21, 0xf7],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x3c, 0x03, 0x04, 0x4b, 0x21, 0xf7],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x3d, 0x03, 0x04, 0x4c, 0x21, 0xf7],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x3e, 0x03, 0x04, 0x4d, 0x21, 0xf7],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x3f, 0x03, 0x04, 0x4e, 0x21, 0xf7],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x40, 0x03, 0x04, 0x4f, 0x21, 0xf7],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x41, 0x03, 0x04, 0x50, 0x21, 0xf7],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x42, 0x03, 0x04, 0x51, 0x21, 0xf7],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x43, 0x01, 0x02, 0xf7],
  [0xf0, 0x00, 0x20, 0x54, 0x30, 0x01, 0x44, 0x01, 0x00, 0xf7],
  [
    0xf0, 0x00, 0x20, 0x54, 0x30, 0x00, 0x70, 0x07, 0x01, 0x40, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xf7,
  ],
];

var midiremote_api = require("midiremote_api_v1");

var driver = midiremote_api.makeDeviceDriver(
  "ESI",
  "Xjam",
  "Steinberg Media Technologies GmbH"
);

var midiIn = driver.mPorts.makeMidiInput("midiIn");
var midiOut = driver.mPorts.makeMidiOutput("midiOut");

driver
  .makeDetectionUnit()
  .detectPortPair(midiIn, midiOut)
  .expectOutputNameStartsWith("Xjam")
  .expectInputNameStartsWith("Xjam");

midiIn.mOnSysex = function (activeDevice, sysexMessage) {
  var isDumpRunning = activeDevice.getState("dumpRunning") === "true";
  if (isDumpRunning === false) return;
  var dumpIndex = Number(activeDevice.getState("dumpIndex")) + 1;

  isDumpRunning = dumpIndex < sysexDump.length;
  activeDevice.setState("dumpRunning", isDumpRunning ? "true" : "false");
  activeDevice.setState("dumpIndex", dumpIndex.toString());

  if (isDumpRunning) midiOut.sendMidi(activeDevice, sysexDump[dumpIndex]);
};

driver.mOnActivate = function (activeDevice) {
  activeDevice.setState("dumpRunning", "true");
  activeDevice.setState("dumpIndex", "0");
  midiOut.sendMidi(activeDevice, sysexDump[0]);
};

var knobZone = driver.mSurface.makeControlLayerZone("knobs");
var knobLayerGreen = knobZone.makeControlLayer("Green");
var knobLayerYellow = knobZone.makeControlLayer("Yellow");
var knobLayerRed = knobZone.makeControlLayer("Red");
var mappedKnobs = [];

var KNOB_SPACING = 2;
var KNOB_SIZE = 2;

for (var i = 0; i < 6; i++) {
  var x = (i % 3) * KNOB_SPACING;
  var y = Math.floor(i / 3) * KNOB_SPACING;
  var knob1 = driver.mSurface.makeKnob(x, y, KNOB_SIZE, KNOB_SIZE);
  mappedKnobs.push(knob1);
  var knob2 = driver.mSurface.makeKnob(x, y, KNOB_SIZE, KNOB_SIZE);
  var knob3 = driver.mSurface.makeKnob(x, y, KNOB_SIZE, KNOB_SIZE);
  knob1.setControlLayer(knobLayerGreen);
  knob1.mSurfaceValue.mMidiBinding
    .setInputPort(midiIn)
    .setOutputPort(midiOut)
    .bindToControlChange(0, i + 64)
    .setTypeRelativeTwosComplement();

  knob2.setControlLayer(knobLayerYellow);
  knob2.mSurfaceValue.mMidiBinding
    .setInputPort(midiIn)
    .setOutputPort(midiOut)
    .bindToControlChange(0, i + 70)
    .setTypeRelativeTwosComplement();
  knob3.setControlLayer(knobLayerRed);
  knob3.mSurfaceValue.mMidiBinding
    .setInputPort(midiIn)
    .setOutputPort(midiOut)
    .bindToControlChange(0, i + 76)
    .setTypeRelativeTwosComplement();
}

var padZone = driver.mSurface.makeControlLayerZone("Pads");
var padLayerGreen = padZone.makeControlLayer("Green");
var padLayerYellow = padZone.makeControlLayer("Yellow");
var padLayerRed = padZone.makeControlLayer("Red");

var mappedPads = [];
var PAD_XOFF = 6.0;
for (var i = 0; i < 16; i++) {
  var x = 1 + (i % 4) * 2.4;
  var y = Math.floor(i / 4) * 2.4;
  var pad1 = driver.mSurface.makeButton(PAD_XOFF + x, y, 2.4, 2.4);
  mappedPads.push(pad1);
  var pad2 = driver.mSurface.makeButton(PAD_XOFF + x, y, 2.4, 2.4);
  var pad3 = driver.mSurface.makeButton(PAD_XOFF + x, y, 2.4, 2.4);

  var row = Math.floor(i / 4);
  var col = i % 4;
  var note = 36 + col + (3 - row) * 4;

  pad1.setControlLayer(padLayerGreen);
  pad1.mSurfaceValue.mMidiBinding
    .setInputPort(midiIn)
    .setOutputPort(midiOut)
    .bindToNote(0, note);
  pad2.setControlLayer(padLayerYellow);
  pad2.mSurfaceValue.mMidiBinding
    .setInputPort(midiIn)
    .setOutputPort(midiOut)
    .bindToNote(1, note);
  pad3.setControlLayer(padLayerRed);
  pad3.mSurfaceValue.mMidiBinding
    .setInputPort(midiIn)
    .setOutputPort(midiOut)
    .bindToNote(2, note);
}

var BLIND_XOFF = 0.9;
driver.mSurface.makeBlindPanel(BLIND_XOFF + 0, 5.6, 2, 1);
driver.mSurface.makeBlindPanel(BLIND_XOFF + 2, 5.6, 2, 1);
driver.mSurface.makeBlindPanel(BLIND_XOFF + 0, 6.6, 2, 1);
driver.mSurface.makeBlindPanel(BLIND_XOFF + 2, 6.6, 2, 1);

driver.mSurface.makeBlindPanel(BLIND_XOFF + 0, 8.6, 2, 1);
driver.mSurface.makeBlindPanel(BLIND_XOFF + 2, 8.6, 2, 1);

var page = driver.mMapping.makePage("Default");

var quickControls = page.mHostAccess.mFocusedQuickControls;

for (var i = 0; i < 6; i++) {
  page.makeValueBinding(
    mappedKnobs[i].mSurfaceValue,
    quickControls.getByIndex(i)
  );
}

page
  .makeValueBinding(
    mappedPads[12].mSurfaceValue,
    page.mHostAccess.mTransport.mValue.mCycleActive
  )
  .setTypeToggle();
page.makeValueBinding(
  mappedPads[13].mSurfaceValue,
  page.mHostAccess.mTransport.mValue.mStop
);
//.setTypeToggle();
page.makeValueBinding(
  mappedPads[14].mSurfaceValue,
  page.mHostAccess.mTransport.mValue.mStart
);
//.setTypeToggle();
page
  .makeValueBinding(
    mappedPads[15].mSurfaceValue,
    page.mHostAccess.mTransport.mValue.mRecord
  )
  .setTypeToggle();
